% Script for plotting number of bubbles vs pressure data as obtained from 
% the experiments carried out within REFLECT deliverable 2.2 for fluids 
% with 1 M NaCl salinity and 200 mmol/kgw of dissolved CO2.
% Different graphs represent different temperatures of the mixtures

clear all
close all
clc

load('1 M NaCl\data_CO2_1M_NaCl_40deg_200mmol\nBubbles_CO2_1M_NaCl_40deg_200mmol.mat');
load('1 M NaCl\data_CO2_1M_NaCl_40deg_200mmol\pressure_CO2_1M_NaCl_40deg_200mmol.mat');

nB_40 = nBubbles(1:5:end);
pressure_40 = pressure_cam;

load('1 M NaCl\data_CO2_1M_NaCl_60deg_200mmol\nBubbles_CO2_1M_NaCl_60deg_200mmol.mat');
load('1 M NaCl\data_CO2_1M_NaCl_60deg_200mmol\pressure_CO2_1M_NaCl_60deg_200mmol.mat');

nB_60 = nBubbles(1:5:end);
pressure_60 = pressure_cam;

load('1 M NaCl\data_CO2_1M_NaCl_100deg_200mmol\nBubbles_CO2_1M_NaCl_100deg_200mmol.mat');
load('1 M NaCl\data_CO2_1M_NaCl_100deg_200mmol\pressure_CO2_1M_NaCl_100deg_200mmol.mat');

nB_100 = nBubbles(1:5:end);
pressure_100 = pressure_cam;

load('1 M NaCl\data_CO2_1M_NaCl_150deg_200mmol\nBubbles_CO2_1M_NaCl_150deg_200mmol.mat');
load('1 M NaCl\data_CO2_1M_NaCl_150deg_200mmol\pressure_CO2_1M_NaCl_150deg_200mmol.mat');

nB_150 = nBubbles(1:5:end);
pressure_150 = pressure_cam;

% Maintaining readable graph by cropping irrelevant data
dx = 10;
s = 100;

plot(pressure_40(1:dx:end-s),nB_40(1:dx:end-s),'k-','MarkerSize',6,'LineWidth',2)
hold on
plot(pressure_60(1:dx:end-s),nB_60(1:dx:end-s),'b-','MarkerSize',6,'LineWidth',2)
plot(pressure_100(1:dx:end-s),nB_100(1:dx:end-s),'g-','MarkerSize',6,'LineWidth',2)
plot(pressure_150(1:dx:end-s),nB_150(1:dx:end-s),'r-','MarkerSize',6,'LineWidth',2)

legend('40 C','60 C','100 C','150 C','Location','NorthWest','FontSize',14)
axis([0 50 0 800])
xlabel('Pressure [bar]')
ylabel('No. of bubbles')
set(gca, 'XDir','reverse')